/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.renders.BuildRender;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.BuildingModes;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class GadgetBuilding
extends AbstractGadget {
    private static final MockBuilderWorld fakeWorld = new MockBuilderWorld();

    public GadgetBuilding() {
        super(OurItems.nonStackableItemProperties(), () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_BUILDING.undoSize).get(), "buildinggadgets_undo_building", Reference.BlockReference.TagReference.WHITELIST_BUILDING, Reference.BlockReference.TagReference.BLACKLIST_BUILDING);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_BUILDING.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_BUILDING.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return () -> new BuildRender(false);
    }

    public boolean placeAtop(ItemStack stack) {
        return GadgetBuilding.shouldPlaceAtop(stack);
    }

    private static void setToolMode(ItemStack tool, BuildingModes mode) {
        CompoundTag tagCompound = tool.m_41784_();
        tagCompound.m_128359_("mode", mode.toString());
    }

    public static BuildingModes getToolMode(ItemStack tool) {
        CompoundTag tagCompound = tool.m_41784_();
        return BuildingModes.getFromName(tagCompound.m_128461_("mode"));
    }

    public static boolean shouldPlaceAtop(ItemStack stack) {
        return !stack.m_41784_().m_128471_("start_inside");
    }

    public static void togglePlaceAtop(Player player, ItemStack stack) {
        stack.m_41784_().m_128379_("start_inside", GadgetBuilding.shouldPlaceAtop(stack));
        player.m_5661_((Component)(GadgetBuilding.shouldPlaceAtop(stack) ? MessageTranslation.PLACE_ATOP : MessageTranslation.PLACE_INSIDE).componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        BuildingModes mode = GadgetBuilding.getToolMode(stack);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add((Component)TooltipTranslation.GADGET_MODE.componentTranslation(mode == BuildingModes.SURFACE && GadgetBuilding.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(new TranslatableComponent(mode.getTranslationKey()).getString()) : new TranslatableComponent(mode.getTranslationKey())).m_6270_(Styles.AQUA));
        tooltip.add((Component)TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).m_6270_(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        if (GadgetBuilding.getToolMode(stack) != BuildingModes.BUILD_TO_ME) {
            tooltip.add((Component)TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetBuilding.getRangeInBlocks(range, mode.getMode())).m_6270_(Styles.LT_PURPLE));
        }
        if (GadgetBuilding.getToolMode(stack) == BuildingModes.SURFACE) {
            tooltip.add((Component)TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetBuilding.getFuzzy(stack))).m_6270_(Styles.GOLD));
        }
        GadgetBuilding.addInformationRayTraceFluid(tooltip, stack);
        tooltip.add((Component)TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetBuilding.shouldPlaceAtop(stack))).m_6270_(Styles.YELLOW));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                InteractionResultHolder<Block> result = GadgetUtils.selectBlock(itemstack, player);
                if (!result.m_19089_().m_19077_()) {
                    player.m_5661_((Component)MessageTranslation.INVALID_BLOCK.componentTranslation(((Block)result.m_19095_()).getRegistryName()).m_6270_(Styles.AQUA), true);
                    return super.m_7203_(world, player, hand);
                }
            } else if (player instanceof ServerPlayer) {
                this.build((ServerPlayer)player, itemstack);
            }
        } else if (!player.m_6144_()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.m_96637_()) {
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        BuildingModes mode = BuildingModes.values()[modeInt];
        GadgetBuilding.setToolMode(heldItem, mode);
    }

    public static void rangeChange(Player player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetBuilding.getToolMode(heldItem) != BuildingModes.SURFACE || range % 2 == 0 ? 1 : 2;
        range = player.m_6144_() ? (range == 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.m_5661_((Component)MessageTranslation.RANGE_SET.componentTranslation(range).m_6270_(Styles.AQUA), true);
    }

    private void build(ServerPlayer player, ItemStack stack) {
        Level world = player.f_19853_;
        ItemStack heldItem = GadgetBuilding.getGadget((Player)player);
        if (heldItem.m_41619_()) {
            return;
        }
        List<BlockPos> coords = GadgetUtils.getAnchor(heldItem).orElse(new ArrayList());
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        if (blockData.getState() == Blocks.f_50016_.m_49966_()) {
            return;
        }
        if (coords.size() == 0) {
            BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)player, stack);
            if (world.m_46859_(lookingAt.m_82425_())) {
                return;
            }
            Direction sideHit = lookingAt.m_82434_();
            coords = GadgetBuilding.getToolMode(stack).getMode().getCollection(new AbstractMode.UseContext(world, blockData.getState(), lookingAt.m_82425_(), heldItem, sideHit, this.placeAtop(stack), GadgetBuilding.getConnectedArea(stack)), (Player)player);
        } else {
            GadgetUtils.setAnchor(stack);
        }
        Undo.Builder builder = Undo.builder();
        IItemIndex index = InventoryHelper.index(stack, (Player)player);
        fakeWorld.setWorldAndState(player.f_19853_, blockData.getState(), (Collection<BlockPos>)coords);
        for (BlockPos coordinate : coords) {
            this.placeBlock(world, player, index, builder, coordinate, blockData);
        }
        this.pushUndo(stack, builder.build(world));
    }

    private void placeBlock(Level world, ServerPlayer player, IItemIndex index, Undo.Builder builder, BlockPos pos, BlockData setBlock) {
        BlockSnapshot blockSnapshot;
        if (pos.m_123342_() > world.m_151558_() || pos.m_123342_() < world.m_141937_() || !player.m_36326_()) {
            return;
        }
        ItemStack heldItem = GadgetBuilding.getGadget((Player)player);
        if (heldItem.m_41619_()) {
            return;
        }
        boolean useConstructionPaste = false;
        BuildContext buildContext = new BuildContext((LevelAccessor)world, (Player)player, heldItem);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        MatchResult match = index.tryMatch(requiredItems);
        if (!match.isSuccess()) {
            if (setBlock.getState().m_155947_()) {
                return;
            }
            match = index.tryMatch(InventoryHelper.PASTE_LIST);
            if (!match.isSuccess()) {
                return;
            }
            useConstructionPaste = true;
        }
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)(blockSnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos)), (Direction)Direction.UP) || !world.m_7966_((Player)player, pos) || !this.canUse(heldItem, (Player)player) || !setBlock.getState().m_60710_((LevelReader)world, pos)) {
            return;
        }
        this.applyDamage(heldItem, player);
        if (index.applyMatch(match)) {
            ImmutableMultiset<IUniqueObject<?>> usedItems = match.getChosenOption();
            builder.record((BlockGetter)world, pos, setBlock, (Multiset<IUniqueObject<?>>)usedItems, (Multiset<IUniqueObject<?>>)ImmutableMultiset.of());
            EffectBlock.spawnEffectBlock((LevelAccessor)world, pos, setBlock, EffectBlock.Mode.PLACE, useConstructionPaste);
        }
    }

    public static ItemStack getGadget(Player player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.m_41720_() instanceof GadgetBuilding)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public boolean performRotate(ItemStack stack, Player player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.ROTATE);
        return true;
    }

    @Override
    public boolean performMirror(ItemStack stack, Player player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.MIRROR);
        return true;
    }
}

